/*
 * Decompiled with CFR 0.152.
 */
package quackertree.pd2.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.DefaultCaret;

public class Main
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar;
    private JButton startButton = new JButton("Start");
    private JTextArea taskOutput;
    private Task task;
    private boolean errorOccured = false;
    private Path tempDir;
    private String PD_DIRECTORY;

    public Main() {
        super(new BorderLayout());
        this.startButton.setActionCommand("start");
        this.startButton.addActionListener(this);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.taskOutput.getCaret();
        caret.setUpdatePolicy(2);
        JPanel panel = new JPanel();
        panel.add(this.startButton);
        panel.add(this.progressBar);
        this.add((Component)panel, "First");
        this.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    public void doTheStuff() {
        try {
            this.writeToLog("Fetching base file...");
            this.downloadFile("https://www.dropbox.com/s/840ab7vl2vez0gz/base.txt?dl=1", "base.txt");
        }
        catch (Exception e) {
            this.writeToLog("Exception occured! - Couldn't download base file!");
            this.errorOut(e);
        }
    }

    public void downloadFile(String s, String shortname) throws Exception {
        URL website = new URL(s);
        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
        FileOutputStream fos = new FileOutputStream(this.tempDir + "/" + shortname);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getPD2Directory() {
        if (Files.exists(Paths.get("C:/Program Files (x86)/Steam/steamapps/common/PAYDAY 2/binkw32.dll", new String[0]), new LinkOption[0])) {
            this.PD_DIRECTORY = "C:/Program Files (x86)/Steam/steamapps/common/PAYDAY 2/";
        } else if (Files.exists(Paths.get("C:/Program Files/Steam/steamapps/common/PAYDAY 2/binkw32.dll", new String[0]), new LinkOption[0])) {
            this.PD_DIRECTORY = "C:/Program Files/Steam/steamapps/common/PAYDAY 2/";
        } else {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File("."));
            chooser.setDialogTitle("Please select your Payday 2 game directory.");
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(this) != 0) {
                this.writeToLog("Exception occured! - Couldn't find Payday 2 game directory!");
                this.errorOut(null);
                return;
            }
            File pointLoc = chooser.getSelectedFile();
            if (!Files.exists(Paths.get(String.valueOf(pointLoc.getAbsolutePath()) + "/binkw32.dll", new String[0]), new LinkOption[0])) {
                this.writeToLog("Exception occured! - The selected Payday 2 game directory is invalid!");
                this.errorOut(null);
                return;
            }
            this.PD_DIRECTORY = pointLoc.getAbsolutePath();
        }
        this.writeToLog("Detected Payday 2 game directory at: " + this.PD_DIRECTORY);
    }

    public void parseBaseFile(Task task) {
        this.writeToLog("Fetching data links from base file...");
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.tempDir + "/base.txt", new String[0]));
            for (String line : lines) {
                String[] splits;
                block10: {
                    splits = line.split("&&");
                    this.writeToLog("Detected mod: " + splits[0].trim());
                    this.writeToLog("Downloading from " + splits[1].trim().replaceFirst("NOTZIP", "") + "...");
                    try {
                        this.downloadFile(splits[1].trim().replaceFirst("NOTZIP", ""), splits[0].trim());
                    }
                    catch (Exception e) {
                        this.writeToLog("Failed downloading " + splits[0].trim() + "!");
                        this.writeToLog(e.getMessage());
                        task.someFailure = true;
                        continue;
                    }
                    task.updateProgress((int)(80.0 / (double)lines.size() / 2.0));
                    this.writeToLog("Download succesfull!");
                    if (!splits[1].contains("NOTZIP")) {
                        this.writeToLog("Unzipping " + splits[0].trim() + "...");
                        try {
                            this.unzipFileInto(this.tempDir + File.separator + splits[0].trim(), new File(String.valueOf(this.PD_DIRECTORY) + File.separator + splits[2].trim()), splits[3].trim());
                            break block10;
                        }
                        catch (Exception e) {
                            this.writeToLog("Failed to unzip " + splits[0].trim() + "!");
                            this.writeToLog(e.getMessage());
                            task.someFailure = true;
                            continue;
                        }
                    }
                    try {
                        Files.copy(Paths.get(this.tempDir + File.separator + splits[0].trim(), new String[0]), Paths.get(String.valueOf(this.PD_DIRECTORY) + File.separator + splits[2].trim() + File.separator + splits[0].trim(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Exception e) {
                        this.writeToLog("Failed to install " + splits[0].trim() + "!");
                        this.writeToLog(e.getMessage());
                        task.someFailure = true;
                        continue;
                    }
                }
                this.writeToLog(String.valueOf(splits[0].trim()) + " installed succesfully!");
                task.updateProgress((int)(80.0 / (double)lines.size() / 2.0));
            }
        }
        catch (Exception e) {
            this.writeToLog("Exception occured! - Couldn't parse base file!");
            this.errorOut(e);
        }
    }

    public void clearBLT() {
        try {
            Main.deleteDir(new File(String.valueOf(this.PD_DIRECTORY) + "/mods/base/"));
            this.writeToLog("Removed existing BLT installation!");
        }
        catch (Exception e) {
            this.writeToLog(e.getMessage());
        }
    }

    public static void deleteDir(File file) throws Exception {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
                System.out.println("Directory is deleted : " + file.getAbsolutePath());
            } else {
                String[] files;
                String[] stringArray = files = file.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    File fileDelete = new File(file, temp);
                    Main.deleteDir(fileDelete);
                    ++n2;
                }
                if (file.list().length == 0) {
                    file.delete();
                    System.out.println("Directory is deleted : " + file.getAbsolutePath());
                }
            }
        } else {
            file.delete();
            System.out.println("File is deleted : " + file.getAbsolutePath());
        }
    }

    public void unzipFileInto(String from, File to, String prefixRemoval) throws Exception {
        if (!to.exists()) {
            to.mkdir();
        }
        ZipFile zipFile = new ZipFile(from);
        Enumeration<? extends ZipEntry> enu = zipFile.entries();
        while (enu.hasMoreElements()) {
            int length;
            ZipEntry zipEntry = enu.nextElement();
            String name = zipEntry.getName();
            this.writeToLog("Unzipping " + name + "...");
            String fileStr = (to + File.separator + name).replaceFirst(prefixRemoval, "");
            File file = new File(fileStr);
            if (name.endsWith("/")) {
                file.mkdirs();
                continue;
            }
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            InputStream is = zipFile.getInputStream(zipEntry);
            FileOutputStream fos = new FileOutputStream(file);
            byte[] bytes = new byte[1024];
            while ((length = is.read(bytes)) >= 0) {
                fos.write(bytes, 0, length);
            }
            is.close();
            fos.close();
        }
        zipFile.close();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.startButton.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    public void writeToLog(String s) {
        this.taskOutput.append(String.valueOf(s) + "\n");
    }

    public void errorOut(Exception e) {
        if (e != null) {
            this.writeToLog(e.getMessage());
        }
        this.writeToLog("Terminating process...");
        this.errorOccured = true;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("PD2 Custom Heist Installer Helper");
        frame.setDefaultCloseOperation(3);
        Main newContentPane = new Main();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.createAndShowGUI();
            }
        });
    }

    public void createTempFolder() {
        try {
            this.writeToLog("Creating temporary directory...");
            this.tempDir = Files.createTempDirectory("pd2chihelper", new FileAttribute[0]);
        }
        catch (Exception e) {
            this.writeToLog("Exception occured! - Failed creating the temporary directory!");
            this.errorOut(e);
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        int progress;
        boolean someFailure;

        Task() {
        }

        @Override
        public Void doInBackground() {
            this.someFailure = false;
            this.progress = 0;
            this.setProgress(0);
            Main.this.createTempFolder();
            if (Main.this.errorOccured) {
                return null;
            }
            this.updateProgress(5);
            Main.this.doTheStuff();
            if (Main.this.errorOccured) {
                return null;
            }
            this.updateProgress(5);
            Main.this.getPD2Directory();
            Main.this.clearBLT();
            if (Main.this.errorOccured) {
                return null;
            }
            this.updateProgress(5);
            Main.this.parseBaseFile(this);
            if (Main.this.errorOccured) {
                return null;
            }
            Main.this.writeToLog("Done!");
            this.setProgress(100);
            if (this.someFailure) {
                Main.this.writeToLog("Some mods weren't installed correctly. The custom heists may not function correctly!");
            }
            return null;
        }

        public void updateProgress(int add) {
            this.progress += add;
            this.setProgress(this.progress);
        }

        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
            Main.this.setCursor(null);
        }
    }
}

