--Override this function to show that you require a skill or difficulty completion
--Usage: See interactiontweakdata: *.requires_upgrade = *
--								   *.difficulty_lock = *

--Duped version of original
function BaseInteractionExt:_has_required_upgrade_fixed(movement_state)

	if not movement_state then
		return true
	end

	if self._tweak_data.requires_upgrade_fixed then
		local category = self._tweak_data.requires_upgrade_fixed.category
		local upgrade = self._tweak_data.requires_upgrade_fixed.upgrade
	
		return managers.player:has_category_upgrade(category, upgrade)
	end

	return true
end

function BaseInteractionExt:_has_required_difficulty_completion(movement_state)

	if not movement_state then
		return true
	end
	
	if self._tweak_data.difficulty_lock then
		local value = managers.mission:get_saved_job_value("parcig_com_" .. self._tweak_data.difficulty_lock)
		return (value and value >= 1)
	end
	
	return true
end

--Display text if can't interact, on selection
BaseInteractionExt.q011_parcigov2 = BaseInteractionExt.selected

function BaseInteractionExt:selected(player, locator, hand_id)
	
	if self.tweak_data == "sc_tape_loop" and not managers.mission:get_job_value("q_favor_cams_on") then
		return false
	end
	
	local pl = alive(player) and player:movement() and player:movement().current_state_name and player:movement():current_state_name()
	
	if not self:_has_required_upgrade_fixed(pl) then
		local text_id = self._tweak_data.upgrade_text_id or "upgrade"
		local text = managers.localization:text(text_id, string_macros)
		local icon = self.no_equipment_icon
		
		managers.hud:show_interact({
			text = text,
			icon = icon
		})
		
		return true
	elseif not self:_has_required_difficulty_completion(pl) then
		local text_id = "q011pc_preplan_req_diff_" .. self._tweak_data.difficulty_lock
		local text = managers.localization:text(text_id, string_macros)
		local icon = self.no_equipment_icon
		
		managers.hud:show_interact({
			text = text,
			icon = icon
		})
		
		return true
	else
		return self:q011_parcigov2(player, locator, hand_id)
	end
end

--Check if can interact (fixed)
BaseInteractionExt.q011_parcigov3 = BaseInteractionExt.can_interact

function BaseInteractionExt:can_interact(player)

	local pl = alive(player) and player:movement() and player:movement().current_state_name and player:movement():current_state_name()
	
	if not self:_has_required_upgrade_fixed(pl) or not self:_has_required_difficulty_completion(pl) then
		return false
	else
		return self:q011_parcigov3(player)
	end
end

--Reinstantiate security camera and inject our own code
SecurityCameraInteractionExt = class(UseInteractionExt)

function UseInteractionExt:interact_start(player, data)

	if(self.tweak_data == "sc_tape_loop" and managers.mission:get_job_value("vo") and managers.mission:get_job_value("vo") == 1 and not managers.mission:get_job_value("has_played_tapeloop_diag")) then
		managers.dialog:queue_dialog("q011pc_diag_favor_camera", {
			skip_idle_check = true,
			case = "russian",
			on_unit = managers.dialog._bain_unit
		})
		
		managers.mission:set_job_value("has_played_tapeloop_diag", 1) --"Abuse" job value to make sure this will reset on heist restart
	end

	return UseInteractionExt.super.interact_start(self, player, data)
end

function SecurityCameraInteractionExt:interact(player)
	SecurityCameraInteractionExt.super.interact(self, player) --WAS .super.super
	
	if(self.tweak_data == "sc_tape_loop") then
		self._unit:base():_hack_parcig_cam_asset()
		self:set_tweak_data("q011pc_preplan_unbuy")
		
		if Network:is_server() then
			self._unit:base():_send_net_event(99) --I use 99; Hopefully OVK never reaches this event number!
		end
	else
		self._unit:base():_unhack_parcig_cam_asset()
		self:set_tweak_data("sc_tape_loop")
		
		managers.player:add_special({
			name = "q011pc_preplan_favor",
			amount = 2
		})
		
		if Network:is_server() then
			self._unit:base():_send_net_event(98) --I use 98; Hopefully OVK never reaches this event number!
		end
	end
	
	self:set_active(true, true)
end

function SecurityCameraInteractionExt:sync_interacted(peer, player, status, skip_alive_check)
	if not self._active then
		return
	end
end